/* $Header: sdo/demo/KMZ/examples/SDOToKMZ.java /main/4 2012/05/08 03:09:32 bkazar Exp $ */

/* Copyright (c) 2006, 2012, Oracle and/or its affiliates. 
All rights reserved. */

/*
   DESCRIPTION
    <short description of component this file declares/defines>

   PRIVATE CLASSES
    <list of private classes defined - with one-line descriptions>

   NOTES
    <other useful comments, qualifications, etc.>

   MODIFIED    (MM/DD/YY)
    rkothuri     10/30/06 - Creation
 */

/**
 *  @version $Header: sdo/demo/KMZ/examples/SDOToKMZ.java /main/4 2012/05/08 03:09:32 bkazar Exp $
 *  @author  rkothuri 
 *  @since   release specific (what release of product did this appear in)
 */

import oracle.spatial.util.*;
//import oracle.spatial.util.GML;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.*;
import java.util.*;
import oracle.jdbc.*;
import java.sql.*;

import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

import oracle.spatial.geometry.*;

import oracle.sql.CLOB;
import oracle.jdbc.*;

//import oracle.jdbc.driver.OracleBlobOutputStream;

import oracle.jdbc.oracore.OracleTypeCLOB;

import oracle.sql.BLOB;
import oracle.sql.STRUCT;

import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.DOMParser;

import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
//import oracle.spatial.geometry.*;
import org.w3c.dom.NodeList;

import org.xml.sax.SAXException;

//package oracle.spatial.SDOToKMZ;

public class SDOToKMZ extends GML
{

    private static String host = "stadb28.us.oracle.com";
    private static String port = "15217";
    private static String sid = "sdo_4";
    private static String driver = "thin";
    private static String user = "scott";
    private static String password = "tiger";
    private static String grpTab = "building_group_3d";
    private static String bldgTab = "building_base_3d";
    private static String roofTab = "building_roof_3d";
    private static String facadeTab = "building_facade_3d";
    private static String geomCol = "Geom";
    private static String grpCol = "geom_bbox";
    private static String txtrCol = "texture";
    private static String clrCol = "colour";
    private static String of_kml = "doc.kml";
    private static String of_dae = "Collada.dae";
    private static String of_txt = "texture.txt";
    private static String jpgpath = "/scratch/rkothuri/view_storage/rkothuri_venkatm_sdo/sdo/demo/KMZ/examples/";
    private static String logofile="";
    
    
    private static  Connection connection = null;
    private static Runtime rnt;
    private static boolean single_kmz = false;
    private static int bldg_id_lb=0;
    private static int bldg_id_ub=0;
    private static ArrayList facadeList = null;
    private static ArrayList bgrpList = null;
    private static ArrayList roofList = null;
    private static ArrayList roofClrs = null;
    private static int logo_buf_lastlen = -1;

    
    /*************************************************************************/
    static private String usage()
    {
      return "Usage: java SDOToKMZ \n" +
             "-host hostName \n-port portNumber\n" +
             "-sid SID \n-driver jdbcDriver[thin:oci]\n" +
             "-user userName\n" +
             "-password password\n" +
             "-comp_table tablename \n" +
             "-feat_table tablename \n" +
             "-geomcol sdo_geometry\n" +
             "-featurecol xmltype\n" +
             "-file inpfile\n"; 
    }

    /*************************************************************************/
    public static void setConnection(){
      String connectString =
                "jdbc:oracle:" + driver + ":@"
                + "(DESCRIPTION=(ADDRESS_LIST=(ADDRESS=(HOST="
                +  host + ")"
                + "(PROTOCOL=tcp)(PORT="
                + port + ")))"
                + "(CONNECT_DATA=(SID="
                + sid + ")))";
                                                                                 
      try {
        DriverManager.registerDriver(new OracleDriver());
        connection = DriverManager.getConnection(
                       connectString, user, password);
                                                                                 
      }
      catch (Throwable t)
      {
        System.out.println(
                        t.toString() + ": \n" + t.getMessage() +
                        "Error attempting to connect to database");
       }

     }
    /*************************************************************************/
    public static Connection getConnection() { return connection; }

    /*************************************************************************/
    private static void processCmdLineArgs(String[] args)
    {
                                                                                 
        // process db connection information
      
          if ( args.length > 0  )
         {
            for ( int i = 0 ; i < args.length ;i++ )
            {
              if ( args[i].equalsIgnoreCase("-host") )
                host = args[++i];
              else if ( args[i].equalsIgnoreCase("-port") )
                port = args[++i];
              else if ( args[i].equalsIgnoreCase("-sid") )
                sid = args[++i];
              else if ( args[i].equalsIgnoreCase("-driver") )
                driver = args[++i];
              else if ( args[i].equalsIgnoreCase("-user") )
                user = args[++i];
              else if ( args[i].equalsIgnoreCase("-password") )
                password = args[++i];
               else if ( args[i].equalsIgnoreCase("-files_path") )
                 jpgpath = args[++i];  
               else if ( args[i].equalsIgnoreCase("-logofile") )
                 logofile = args[++i];  
               else if ( args[i].equalsIgnoreCase("-bldg_grp_id_lb") )
                 bldg_id_lb = new Integer(args[++i]).intValue();  
               else if ( args[i].equalsIgnoreCase("-bldg_grp_id_ub") )
                 bldg_id_ub = new Integer(args[++i]).intValue();  
                    
              else if ( args[i].equalsIgnoreCase("-h") )
              {
                 System.out.println(usage());
                 System.exit(0);
              }
           }
         }
	 else {
                System.out.println("Using default parameters: ");
         }
         setConnection();
      
    }
    /*************************************************************************/

 /*
     public static void writegm(int featid, int gmid, JGeometry gm) {
         final Connection conn = getConnection();
         PreparedStatement  stmt = null;
         String sqlStr =
           " insert into "+ geomTable + " values (?, ?, ?)";
         try
         {
             //System.out.println(sqlStr);
           conn.setAutoCommit(true);
           stmt = conn.prepareCall(sqlStr);
           STRUCT dbobj = JGeometry.store(gm, conn);   
                               
           stmt.setInt(1, featid);
           stmt.setInt(2, gmid);
           stmt.setObject(3, dbobj);
           stmt.executeUpdate();
                                                                                           
         }
         catch ( SQLException e1 )
           { System.out.println("Error: "+e1.getMessage());}
         finally {  
           try {
             if (stmt !=null)     {stmt.close(); stmt = null;}
           } catch ( SQLException e ) {}
         }      
     }
     public static Vector getGeometry(
       Node    start,
       String  geometryTypes[])
     {
       Vector result = new Vector();
       getGeometry(start, geometryTypes, result);
       return result;
     }
                                                                                    
     public static void getGeometry(
       Node    start,
       String  geometryTypes[],
       Vector  result)
     {
       for(Node child = start.getFirstChild();
           child != null;
           child = child.getNextSibling())
       {
         String str = new String(child.getNodeName());
         System.out.println(str);
         if(match(str, geometryTypes))
         //normalize(child.getNodeName()).equalsIgnoreCase(path[posInPath]))
         {        
             result.add(child);
         }
         else
           getGeometry(child, geometryTypes, result);
       }
     }
                        
    public static XMLDocument getXMLDocFromNode(Node nd) throws IOException {                                                            
      XMLDocument d =  new XMLDocument();
      Node dRoot = d.importNode(nd, true);
      d.appendChild(dRoot);
      String str = d.toString();
      //d.print(System.out);
    
      return d;
    }
    */
    
   /* public static writeKML(File f, int bgrp_id, 
                           int bldg_id, int face_id, int roof){
    f.
                               
    }*/

public static void zwriteimg(ZipOutputStream zout, BLOB image) throws SQLException,
                                                            IOException {
    long                blobLength;
    long                position;
    int                 chunkSize;
    byte[]              binaryBuffer;
    int                 bytesRead                   = 0;
    int                 bytesWritten                = 0;
    int                 totbytesRead                = 0;
    int                 totbytesWritten             = 0;


        blobLength = image.length();
        chunkSize = image.getChunkSize();
        binaryBuffer = new byte[chunkSize];

        for (position = 1; position <= blobLength; position += chunkSize) {

            // Loop through while reading a chunk of data from the BLOB
            // column using the getBytes() method. This data will be stored
            // in a temporary buffer that will be written to disk.
            bytesRead = image.getBytes(position, chunkSize, binaryBuffer);

            // Now write the buffer to disk.
            zout.write(binaryBuffer, 0, bytesRead);

            totbytesRead += bytesRead;
            totbytesWritten += bytesRead;
        }
}


public static void writeFacade(ZipOutputStream zout,
  String dirpath, int bgid, int bid, int fid,
  double longmin, double latmin, double orient, double height, double length,
  double c1, double c2, double c3,
  BLOB image) throws FileNotFoundException,
                                       UnsupportedEncodingException,
                                       IOException, SQLException,
                                                  InterruptedException {
                                       
        
        
    String dkid = "BG" + bgid + "_B" + bid + "_F" + fid;
    String strjpg = dkid +".jpg";   
    String strkml = dkid +".kml";
    String strdae = dkid + ".dae";
    
    // add facade kml to facadeList
    facadeList.add(strkml);
          
    
    zout.putNextEntry(new ZipEntry(strkml));
    
    // write the kml file 
    zappend(zout, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + 
    "<kml xmlns=\"http://earth.google.com/kml/2.1\">\n"  
    + "<Placemark>\n");
    zappend(zout, "    <name>" + dkid + "</name>\n");
    zappend(zout,"    <Model>\n" + 
    "        <altitudeMode>relativeToGround</altitudeMode>\n" + 
    "        <Location>\n");
    zappend(zout,"            <longitude>"+ longmin+"</longitude>\n");
    zappend(zout,"            <latitude>"+ latmin+"</latitude>\n"); 
    zappend(zout,"            <altitude>0.000000000000</altitude>\n" + 
    "        </Location>\n" + 
    "        <Orientation>\n");
    zappend(zout,"            <heading>"+ orient+"</heading>");

    zappend(zout,"            <tilt>0</tilt>\n" + 
    "            <roll>0</roll>\n" + 
    "        </Orientation>\n" + 
    "        <Scale>\n" + 
    "            <x>1.0</x>\n" + 
    "            <y>1.0</y>\n" + 
    "            <z>1.0</z>\n" + 
    "        </Scale>\n" + 
    "        <Link>\n" + 
    "            <href>"+ strdae + "</href>\n" + 
    "        </Link>\n" + 
    /*"  <ResourceMap id=\"resourcemap_for_model_"+dkid+"\">\n" + 
    "    <Alias>\n" + 
    "      <sourceHref>../files/"+dkid+".jpg</sourceHref>\n" + 
    "      <targetHref>../files/"+dkid+".jpg </targetHref>\n" + 
    "    </Alias>\n" + 
    "    </ResourceMap>\n" + */  
    "    </Model>\n" + 
    "</Placemark>\n" + 
    "</kml>\n");
    zout.closeEntry();
    
    zout.putNextEntry(new ZipEntry(strdae));
    
    // now write the collada file 
    zappend(zout,"<?xml version=\"1.0\" encoding=\"utf-8\"?>\n" + 
    "<COLLADA xmlns=\"http://www.collada.org/2005/11/COLLADASchema\" version=\"1.4.1\">\n" + 
    "   <asset>\n" + 
    "      <contributor>\n" + 
    "         <authoring_tool>Oracle Jdeveloper for Spatial 3D KMZ Demo</authoring_tool>\n" + 
    "      </contributor>\n" + 
    "      <created>2007-10-25T12:05:10Z</created>\n" + 
    "      <modified>2007-10-25T12:05:10Z</modified>\n" + 
    "      <unit name=\"meters\" meter=\"1.0\"/>\n" + 
    "      <up_axis>Z_UP</up_axis>\n" + 
    "   </asset>\n" + 
    "   <library_images>\n" + 
    "      <image id=\""+dkid+"-image\" name=\""+dkid+"-image\">\n" + 
    "         <init_from>./"+strjpg+"</init_from>\n" + 
    "      </image>\n" + 
    "   </library_images>\n" + 
    "   <library_materials>\n" + 
    "      <material id=\""+dkid+"ID\" name=\""+dkid+"\">\n" + 
    "         <instance_effect url=\"#"+dkid+"-effect\"/>\n" + 
    "      </material>\n" + 
    "   </library_materials>\n");
    
    zappend(zout,"   <library_effects>\n" + 
    "      <effect id=\""+dkid+"-effect\" name=\""+dkid+"-effect\">\n" + 
    "         <profile_COMMON>\n" + 
    "            <newparam sid=\""+dkid+"-image-surface\">\n" + 
    "               <surface type=\"2D\">\n" + 
    "                  <init_from>"+dkid+"-image</init_from>\n" + 
    "               </surface>\n" + 
    "            </newparam>\n" + 
    "            <newparam sid=\""+dkid+"-image-sampler\">\n" + 
    "               <sampler2D>\n" + 
    "                  <source>"+dkid+"-image-surface</source>\n" + 
    "               </sampler2D>\n" + 
    "            </newparam>\n" + 
    "            <technique sid=\"COMMON\">\n" + 
    "               <phong>\n" + 
    "                  <emission>\n" + 
    "                     <color> "+ c1 +" " + c2 + " " + c3 +"  1</color>\n" + 
    "                  </emission>\n" + 
    "                  <ambient>\n" + 
    "                     <color>0.000000 0.000000 0.000000 1</color>\n" + 
    "                  </ambient>\n" + 
    "                  <diffuse>\n" + 
    "                     <texture texture=\""+dkid+"-image-sampler\" texcoord=\"UVSET0\"/>\n" + 
    "                  </diffuse>\n" + 
    "                  <specular>\n" + 
    "                     <color>0.000000 0.000000 0.000000 1</color>\n" + 
    "                  </specular>\n" + 
    "                  <shininess>\n" + 
    "                     <float>20.000000</float>\n" + 
    "                  </shininess>\n" + 
    "                  <reflectivity>\n" + 
    "                     <float>0.100000</float>\n" + 
    "                  </reflectivity>\n" + 
    "                  <transparent>\n" + 
    "                     <color>1 1 1 1</color>\n" + 
    "                  </transparent>\n" + 
    "                  <transparency>\n" + 
    "                     <float>0.000000</float>\n" + 
    "                  </transparency>\n" + 
    "               </phong>\n" + 
    "            </technique>\n" + 
    "         </profile_COMMON>\n" + 
    "      </effect>\n" + 
    "   </library_effects>\n");
    zappend(zout,"   <library_geometries>\n" + 
    "      <geometry id=\"mesh1-geometry\" name=\"mesh1-geometry\">\n" + 
    "         <mesh>\n" + 
    "            <source id=\"mesh1-geometry-position\">\n" + 
    "               <float_array id=\"mesh1-geometry-position-array\" count=\"12\"> 0.0 "+ 
      length +" 0.0 0.0 0.0 0.0   0.0 "+ length +" " + height + " " + " 0.0 0.0 " + height +" </float_array>\n" + 
    "               <technique_common>\n" + 
    "                  <accessor source=\"#mesh1-geometry-position-array\" count=\"4\" stride=\"3\">\n" + 
    "                     <param name=\"X\" type=\"float\"/>\n" + 
    "                     <param name=\"Y\" type=\"float\"/>\n" + 
    "                     <param name=\"Z\" type=\"float\"/>\n" + 
    "                  </accessor>\n" + 
    "               </technique_common>\n" + 
    "            </source>\n" + 
    "            <source id=\"mesh1-geometry-uv\">\n" + 
    "               <float_array id=\"mesh1-geometry-uv-array\" count=\"8\"> 0.000000 0.000000 1.000000 0.000000 0.000000 1.000000 1.000000 1.000000 </float_array>\n" + 
    "               <technique_common>\n" + 
    "                  <accessor source=\"#mesh1-geometry-uv-array\" count=\"4\" stride=\"2\">\n" + 
    "                     <param name=\"S\" type=\"float\"/>\n" + 
    "                     <param name=\"T\" type=\"float\"/>\n" + 
    "                  </accessor>\n" + 
    "               </technique_common>\n" + 
    "            </source>\n" + 
    "            <vertices id=\"mesh1-geometry-vertex\">\n" + 
    "               <input semantic=\"POSITION\" source=\"#mesh1-geometry-position\"/>\n" + 
    "            </vertices>\n" + 
    "            <triangles material=\""+dkid+"\" count=\"4\">\n" + 
    "               <input semantic=\"VERTEX\" source=\"#mesh1-geometry-vertex\" offset=\"0\"/>\n" + 
    "             <input semantic=\"TEXCOORD\" source=\"#mesh1-geometry-uv\" offset=\"1\" set=\"0\"/>\n" + 
    "               <p>0 0 1 1 2 2 0 0 2 2 1 1 3 3 2 2 1 1 3 3 1 1 2 2 </p>\n" + 
    "            </triangles>\n" + 
    "         </mesh>\n" + 
    "      </geometry>\n" + 
    "   </library_geometries>\n");
    zappend(zout,"   <library_visual_scenes>\n" + 
    "      <visual_scene id=\"SketchUpScene\" name=\"SketchUpScene\">\n" + 
    "         <node id=\"Model\" name=\"Model\">\n" + 
    "            <node id=\"mesh1\" name=\"mesh1\">\n" + 
    "               <instance_geometry url=\"#mesh1-geometry\">\n" + 
    "                  <bind_material>\n" + 
    "                     <technique_common>\n" + 
    "                        <instance_material symbol=\""+dkid+"\" target=\"#"+dkid+"ID\">\n" + 
    "                           <bind_vertex_input semantic=\"UVSET0\" input_semantic=\"TEXCOORD\" input_set=\"0\"/>\n" + 
    "                        </instance_material>\n" + 
    "                     </technique_common>\n" + 
    "                  </bind_material>\n" + 
    "               </instance_geometry>\n" + 
    "            </node>\n" + 
    "         </node>\n" + 
    "      </visual_scene>\n" + 
    "   </library_visual_scenes>\n" + 
    "   <scene>\n" + 
    "      <instance_visual_scene url=\"#SketchUpScene\"/>\n" + 
    "   </scene>\n" + 
    "</COLLADA>");
    
    //daeout.close();
    zout.closeEntry();
    
    // then write the jpg
    zout.putNextEntry(new ZipEntry(strjpg));
     
    zwriteimg(zout, image);
        
 /*
    Connection conn = getConnection();
    CallableStatement cstmt = conn.prepareCall("{CALL write_picture(?, ?, ?,?)}");
    //cstmt.registerOutParameter(1, Types.FLOAT);
    cstmt.setString(1, dirpath);
    cstmt.setInt(2, bgid);
    cstmt.setInt(3, bid);
    cstmt.setInt(4, fid);
    cstmt.executeUpdate();
    cstmt.close();
*/   
    zout.closeEntry();
    
    }
    
    public static void writeBldg(ZipOutputStream zout,
                                 String dirpath, int bgid, int bid) 
                                 throws FileNotFoundException,
                                       UnsupportedEncodingException,
                                       IOException, SQLException,
                                                 InterruptedException

    {
        Connection conn = getConnection();
        PreparedStatement gstmt = null;
        ResultSet gset = null;
        String sqlStr = "SELECT facade_id, " + 
            " a.g.x, a.g.y, a.g.z, " +
            
            "height, length, texture from " +
            "(select facade_id, corner_and_heading(geom) g, " +
            " get_height(geom) height, get_length(geom) length, " +
            " texture from " + facadeTab +
            " where building_id= ? ) a"; 
         
        
        try
        {
          gstmt = conn.prepareStatement(sqlStr);
          gstmt.setInt(1,bid);
          gset = gstmt.executeQuery();
          
          

          while (gset.next())
          {
            int fid = gset.getInt(1);
            double longmin = gset.getDouble(2);
            double latmin = gset.getDouble(3);
            double heading = gset.getDouble(4);   
        
            double height = gset.getDouble(5);
            double len = gset.getDouble(6);
            BLOB image = (BLOB) gset.getBlob(7); 
            /* double c_r = gset.getDouble(7);
            double c_g = gset.getDouble(8);
            double c_b = gset.getDouble(9); */
            
            writeFacade(zout, dirpath, bgid, bid, fid, longmin, latmin, heading, 
                        height, len, 0.0,0.0,0.0, image);

            
            //Statement bstmt = null;
            //ResultSet bset = null;
            //File dockml = new File(ndir, "doc.kml");
            //File coldae = new File(ndir, "Collada.dae");
            
            
            
          }
        } catch (SQLException e) {
          System.out.println("Error: " + e.getMessage());
        }
        finally {
           {
            if (gset != null)    {gset.close(); gset = null;}
            if (gstmt !=null)     {gstmt.close(); gstmt = null;}
          }
        }
        
    }
    
    public static void zappend(ZipOutputStream zout, String str) throws UnsupportedEncodingException,
                                                  IOException {
        if (str == null) return;
        if (str.length()== 0) return;
        bzappend(zout, str.getBytes("UTF-8"));

    }
    public static void bzappend(ZipOutputStream zout, byte[] b) throws IOException {
        //Byte buf[512];
        
        zout.write(b);
    }
    
    
    public static void writeBgrp(ArrayList logo_buf, OutputStreamWriter out,
                    String dirpath, int bgid) throws FileNotFoundException,
                                       UnsupportedEncodingException,
                                       IOException, SQLException,
                                                  InterruptedException

    {
   
        
    
        facadeList = new ArrayList<String>(25);
        roofList = new ArrayList<String>(10);
        roofClrs = new ArrayList<String>(10);
           
        String bgkml_pre = "BG"+bgid;
        String bgkml = bgkml_pre + ".kml";
        ZipOutputStream zout = new ZipOutputStream(
                       new FileOutputStream(bgkml_pre+".kmz")) ;
        
        zout.setMethod(ZipOutputStream.DEFLATED);


         zout.putNextEntry(new ZipEntry("oralogo_small.png"));
         if (logo_buf_lastlen > 0) {
         int sz = logo_buf.size();
         for(int i=0; i<sz-1; i++) {
           zout.write((byte[]) (logo_buf.get(i)));
         }
         zout.write((byte[])(logo_buf.get(sz-1)), 0, logo_buf_lastlen);
         }
         zout.closeEntry();
 
        Connection conn = getConnection();

        // get MBR of bgrp
         double minx=13, miny=52, maxx=13, maxy=52;
         PreparedStatement gstmt = null;
         ResultSet gset = null;
         String sqlStr = "SELECT " +
        "sdo_geom.sdo_min_mbr_ordinate(geom, 1)," + 
        "sdo_geom.sdo_min_mbr_ordinate(geom, 2)," +
        "sdo_geom.sdo_max_mbr_ordinate(geom, 1)," +
        "sdo_geom.sdo_max_mbr_ordinate(geom, 2) " +
        "from (select sdo_aggr_mbr(geom) geom from building_base_3d  " +
             " where bgrp_id =? )  " ;
          
         
         try
         {
           
           gstmt = conn.prepareStatement(sqlStr);
           gstmt.setInt(1,bgid);
           gset = gstmt.executeQuery();
             
           while (gset.next())
           {
               
               minx = gset.getDouble(1);
               miny = gset.getDouble(2);
               maxx = gset.getDouble(3);
               maxy = gset.getDouble(4);          
           }
         } catch (SQLException e) {
           System.out.println("Error: " + e.getMessage());
         }
         finally {
            {
             if (gset != null)    {gset.close(); gset = null;}
             if (gstmt !=null)     {gstmt.close(); gstmt = null;}
           }
         }


        // write bgkml file
        zout.putNextEntry(new ZipEntry(bgkml));
        zappend(zout, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + 
          "<kml xmlns=\"http://earth.google.com/kml/2.1\">\n" + 
          "<Folder>\n" + 
        //  " <Placemark>" +
          "        <name>Building Group "+bgid+"</name>\n" +
          "        <LookAt>\n" + 
          "            <longitude>" + minx + "</longitude>\n" + 
          "            <latitude> "+ miny +"</latitude>\n" + 
          "            <range>437.2393107680517</range>\n" + 
          "            <tilt>65.74454495876547</tilt>\n" + 
          "            <heading>-165.70337734057933</heading>\n" + 
          "         </LookAt>\n" + 
          "         <Region>\n" +
          "            <LatLonAltBox>\n" +
          "                       <south>"+miny+" </south>\n" +
          "                       <north>"+maxy+" </north>\n" +
          "                       <east>" +maxx +" </east>\n" +
          "                       <west> "+minx+" </west>\n" +
          "                       <minAltitude>0 </minAltitude>\n" +
          "                       <maxAltitude>0</maxAltitude>\n" +
          "            </LatLonAltBox>\n" +
          "            <Lod>\n" +
          "                       <minLodPixels>9</minLodPixels>\n" +
          "                       <minFadeExtent>16</minFadeExtent>\n" +
          "                       <maxFadeExtent>-1</maxFadeExtent>\n" +
          "                       <maxLodPixels>-1</maxLodPixels>\n" +
          "            </Lod>\n" +
          "         </Region>\n" +        
/*          "         <ScreenOverlay>\n" + 
          "            <name> Oracle and TeleAtlas </name>\n" + 
          "            <Icon>\n" + 
          "                 <href>oralogo_small.png</href>\n" + 
          "            </Icon>\n" + 
          "            <overlayXY x=\"0\" y=\"0\" xunits=\"fraction\" yunits=\"fraction\"/>\n" + 
          "            <screenXY x=\"25\" y=\"25\" xunits=\"pixels\" yunits=\"pixels\"/>\n" + 
          "            <rotationXY x=\"0.5\" y=\"0.5\" xunits=\"fraction\" yunits=\"fraction\"/>\n" + 
          "            <size x=\"80\" y=\"51\" xunits=\"pixels\" yunits=\"pixels\"/>\n" + 
          "         </ScreenOverlay>\n" +
*/          "\n" +
          "         <open>1</open>\n");      
        //zappend(zout,"\n <Placemark>\n" +
        //"<name>"+ bgid+"</name>\n");
        
        // write all the roofs first
         gstmt = null;
         gset = null;
         sqlStr = "SELECT b.building_id, b.roof_colour, " + 
             "to_char(sdo_util.to_kmlgeometry(b.geom)) " + 
             " from  building_base_3d a, building_roof_3d b " +
             " where a.bgrp_id =?  and b.building_id = a.building_id " ;
          
         
         try
         {
           
           gstmt = conn.prepareStatement(sqlStr);
           gstmt.setInt(1,bgid);
           gset = gstmt.executeQuery();
             
           while (gset.next())
           {
             int bid = gset.getInt(1);
             String roof_colour = "ff"+gset.getString(2); // add ff for "alpha"
             
             //writeBldg(zout, dirpath, bgid, bid);
             
             
             String roof_geom = gset.getString(3);
             /*
             oracle.sql.CLOB aclob = (CLOB)gset.getObject(3);
               
             //Reader ip = aclob.ggetCharacterStream();
               
             char [] carr = new char[10000];  
             while(ip.read(carr,0,10000)>0){
               bgkmlout.write(carr);
             }
             */
             
    //         if (!(aclob.isEmptyLob())) {
            if ((roof_geom!=null) && (roof_geom.length()>0)) {
                 zappend(zout, "<Style id=\"Sty_"+bgid+"_"+bid+"_le\"><LineStyle><width>0.2</width><color>"+roof_colour+"</color></LineStyle><PolyStyle><color>ff76829D</color></PolyStyle></Style>\n" +
                 "<Placemark>\n" + 
                 "   <name>BuildingRoof"+bgid+"_"+bid+"</name>\n" + 
                 "   <styleUrl>#Sty_"+bgid+"_"+bid+"_le</styleUrl>\n");
                 
                 /*char [] carr = new char[10000];  
                 while(ip.read(carr,0,10000)>0){
                   zout,carr);
                 }*/
                 //zout.write(aclob.getBytes());
                 zappend(zout, roof_geom);            
                 zappend(zout,"\n </Placemark>\n");               
             }
           }
         } catch (SQLException e) {
           System.out.println("Error: " + e.getMessage());
         }
         finally {
            {
             if (gset != null)    {gset.close(); gset = null;}
             if (gstmt !=null)     {gstmt.close(); gstmt = null;}
           }
         }
         
      
        gstmt = null;
        gset = null;
        sqlStr = "SELECT b.building_id, b.facade_id  " +
            " from building_base_3d a, building_facade_3d b " +
            " where a.bgrp_id =? and b.building_id=a.building_id " ;
         
        
        try
        {
          
          gstmt = conn.prepareStatement(sqlStr);
          gstmt.setInt(1,bgid);
          gset = gstmt.executeQuery();
            
          while (gset.next())
          {
            int bid = gset.getInt(1);
            int fid = gset.getInt(2);  
          
            zappend(zout,"           <NetworkLink>\n" + 
                      "                   <name>Facade: BG"+bgid+"_B"+bid+"_F"+fid+"</name>\n" + 
                      "                           <Url>\n" + 
                      "                                   <href>BG"+bgid+"_B"+bid+"_F"+fid+".kml</href>\n" + 
                      "                           </Url>\n" + 
                      "           </NetworkLink>\n");                     
            
          }
        } catch (SQLException e) {
          System.out.println("Error: " + e.getMessage());
        }
        finally {
           {
            if (gset != null)    {gset.close(); gset = null;}
            if (gstmt !=null)     {gstmt.close(); gstmt = null;}
          }
        }  
        //zappend(zout,"\n </Placemark>\n");
        zappend(zout,"       </Folder>\n" + 
        "</kml>");
        zout.closeEntry();
        
              
        // now write all the facades, dae etc.
        
         gstmt = null;
         gset = null;
         sqlStr = "SELECT building_id " + 
             " from  building_base_3d b " +
             " where bgrp_id =?  " ;
          
         
         try
         {
           
           gstmt = conn.prepareStatement(sqlStr);
           gstmt.setInt(1,bgid);
           gset = gstmt.executeQuery();
             
           while (gset.next())
           {
             int bid = gset.getInt(1);     
             
             writeBldg(zout, dirpath, bgid, bid);
             
           }
         } catch (SQLException e) {
           System.out.println("Error: " + e.getMessage());
         }
         finally {
            {
             if (gset != null)    {gset.close(); gset = null;}
             if (gstmt !=null)     {gstmt.close(); gstmt = null;}
           }
         }
         
        
        zout.close();
    
    }
/*
 * Given i/p centerlong lat, identify area 
 * and then identify the building_group, building_id, facade_id
 * 
 * For each bgid in given area do:
 *   Foreach bid in given bgid  do:
 *     writefacades(bgid, bid);
 *     writeBuildings (bid, roofs, facades);
 *   
 */
  public static void main(String args[]) 
    throws
      FileNotFoundException,
      IOException, SQLException,
      SAXException,
                                                  InterruptedException {    
   
    // perform the connections, process arguments
    processCmdLineArgs(args);
    rnt = Runtime.getRuntime();
    
     
           
      FileInputStream logo_file = new FileInputStream("oralogo_small.png");
      //int len = (int) logo_file.;
      int len;     
      byte[] buf = new byte[1024];
      ArrayList logo_buf = new ArrayList<byte[]>(10);
      
      
      while ((len = logo_file.read(buf))>0) {  
        logo_buf.add(buf);
        buf = new byte[1024];
        logo_buf_lastlen = len;
      }

      OutputStreamWriter kmlout = 
        new OutputStreamWriter(new FileOutputStream("doc.kml"), "UTF-8");
      
      kmlout.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + 
      "<kml xmlns=\"http://earth.google.com/kml/2.1\">\n" + 
      "<Folder>\n" + 
      "        <name>3-D Buildings Demo</name>\n" +
      "        <LookAt>\n" + 
      "            <longitude> 13.346613888888</longitude>\n" + 
      "            <latitude> 52.5295361111</latitude>\n" + 
      "            <range>437.2393107680517</range>\n" + 
      "            <tilt>65.74454495876547</tilt>\n" + 
      "            <heading>-165.70337734057933</heading>\n" + 
      "         </LookAt>\n" + 
      "        <ScreenOverlay>\n" + 
      "		<name> Oracle and TeleAtlas </name>\n" + 
      "		<Icon>\n" + 
      "			<href>oralogo_small.png</href>\n" + 
      "		</Icon>\n" + 
      "		<overlayXY x=\"0\" y=\"0\" xunits=\"fraction\" yunits=\"fraction\"/>\n" + 
      "		<screenXY x=\"25\" y=\"35\" xunits=\"pixels\" yunits=\"pixels\"/>\n" + 
      "		<rotationXY x=\"0.5\" y=\"0.5\" xunits=\"fraction\" yunits=\"fraction\"/>\n" + 
      "		<size x=\"120\" y=\"25\" xunits=\"pixels\" yunits=\"pixels\"/>\n" + 
      "   	</ScreenOverlay>\n");
    
    if (logofile.length()>0)
      kmlout.append(
      "        <ScreenOverlay>\n" + 
      "         <name> Oracle and TeleAtlas </name>\n" + 
      "         <Icon>\n" + 
      "                 <href>"+logofile+"</href>\n" + 
      "         </Icon>\n" + 
      "         <overlayXY x=\"0\" y=\"0\" xunits=\"fraction\" yunits=\"fraction\"/>\n" + 
      "         <screenXY x=\"525\" y=\"15\" xunits=\"pixels\" yunits=\"pixels\"/>\n" + 
      "         <rotationXY x=\"0.5\" y=\"0.5\" xunits=\"fraction\" yunits=\"fraction\"/>\n" + 
      "         <size x=\"120\" y=\"61\" xunits=\"pixels\" yunits=\"pixels\"/>\n" + 
      "         </ScreenOverlay>\n" +
      "\n" );
   kmlout.append("         <open>1</open>\n");
      
    
    String sqlStr;
    String lb_str = " " ;
    String ub_str = " " ;
    
    if (bldg_id_lb > 0) 
      lb_str = new String (" and bgrp_id >= " + bldg_id_lb);
    if (bldg_id_ub > 0) 
      ub_str = new String (" and bgrp_id <= " + bldg_id_ub);

    //bldg_ids = 325;
      sqlStr 
      = new String("SELECT bgrp_id from " + grpTab +
        " where  1=1  "  + lb_str + ub_str 
       //+ "(bgrp_id < 350 and bgrp_id>300 and bgrp_id<>304 and bgrp_id<>305)   "
      //+ " (bgrp_id>102 and bgrp_id<148) "
       //+ " bgrp_id=325 or bgrp_id=243 "
        +" order by bgrp_id");
                    
    Connection conn = getConnection();
    Statement gstmt = null;
    ResultSet gset = null;
    
    
    //writeFacade(jpgpath, 2,2,12,13.340853, 52.5158821, 263.78, 28.84, 12.6, 0.0, 0.0, 0.0 );

    
    try
    {
      gstmt = conn.createStatement();
      gset = gstmt.executeQuery(sqlStr);
      
      

      while (gset.next())
      {
        int bgrp_id = gset.getInt(1);
    
        writeBgrp(logo_buf, kmlout, jpgpath, bgrp_id); 
        kmlout.append("           <NetworkLink>\n" + 
                  "                   <name>BGgrp"+bgrp_id+"</name>\n" + 
                  "                           <Url>\n" + 
                  "                                   <href>BG"+bgrp_id+".kmz</href>\n" + 
                  "                                   <viewRefreshMode>onRegion</viewRefreshMode>"+
                  "                           </Url>\n" + 
                  "           </NetworkLink>\n");
          
        
      }
    } 
    catch (SQLException e) {
      System.out.println("Error: " + e.getMessage());
    }
    finally {
       {
        if (gset != null)    {gset.close(); gset = null;}
        if (gstmt !=null)     {gstmt.close(); gstmt = null;}
      }
    }
    
     kmlout.append("       </Folder>\n" + 
     "</kml>");
     kmlout.close();
  
  }
}

